﻿var isGridsInitializing = true;

document.addEventListener("DOMContentLoaded", function () {
    initGrids();

    $(window).on("load", function () {
        isGridsInitializing = false;
    });

    initGridOpenEnds();
});

function initGrids() {
    // Fix width of text inputs
    $("table.grid").each(function () {
        var _table = $(this);

        //Hack to being able to get element width when it's hidden
        _table.css({ position: "absolute", visibility: "hidden", display: "block" });

        $("tbody tr table.control, tfoot tr table.control", _table).each(function () {
            var _leftCell = $(this).find("td.leftControls");
            var _rightCell = $(this).find("td.rightControls");

            _leftCell.css({ position: "absolute", visibility: "hidden", display: "block" });
            _rightCell.css({ position: "absolute", visibility: "hidden", display: "block" });

            if ($("span", _leftCell).width() > 0) {
                _leftCell.width($("span", _leftCell).outerWidth(true));
            }
            else {
                _leftCell.hide();
            }

            if ($("span", _rightCell).width() > 0) {
                _rightCell.width($("span", _rightCell).outerWidth(true));
            }
            else {
                _rightCell.hide();
            }

            _leftCell.css({ position: "", visibility: "", display: "" });
            _rightCell.css({ position: "", visibility: "", display: "" });
        });

        _table.css({ position: "", visibility: "", display: "" });

        refreshGridHeaders(_table);
    });

    function addBackgroundColorStyle(elements, cssClass) {
        $(elements).each(function () {
            if (!$(this).hasClass(cssClass)) {
                var bgColor = $(this).css('background-color');

                if (!$(this).attr('data-background-color') && bgColor) {
                    $(this).attr('data-background-color', bgColor);
                }

                $(this).css('background-color', '');
                $(this).attr('data-bg-classes', Number($(this).attr('data-bg-classes') || 0) + 1);
                $(this).addClass(cssClass);
            }

        });
    }

    function removeBackgroundColorStyle(elements, cssClass) {
        $(elements).each(function () {
            if ($(this).hasClass(cssClass)) {
                var numBgClasses = Number($(this).attr('data-bg-classes') || 0) - 1;
                $(this).attr('data-bg-classes', numBgClasses);
                $(this).removeClass(cssClass);
                if (numBgClasses === 0 && $(this).attr('data-background-color')) {
                    $(this).css('background-color', $(this).attr('data-background-color'));
                }
            }
        });
    }

    function GetAxisElements(cell) {
        var row = cell.closest("tr");
        var elements = $(".gridItem:not(.gridColumnHeader)", row).filter(function (index) {
            var rowspan = $(this).attr("rowspan");
            return rowspan == undefined || rowspan == 1;
        });
        var hasColumn = cell.attr("data-column-position");
        var dataColumnCount = $("td[data-column-position]", row).length;

        if (hasColumn && dataColumnCount > 1) {
            var table = cell.closest("table");
            var columnPosition = cell.attr("data-column-position");
            var choicePosition = cell.attr("data-choice-position");

            if (columnPosition != undefined) {
                var columns;

                if (choicePosition != undefined) {
                    columns = $(".gridItem[data-column-position=" + columnPosition + "][data-choice-position=" + choicePosition + "]", table);
                }
                else {
                    columns = $(".gridItem[data-column-position=" + columnPosition + "]", table);
                }

                elements = elements.add(columns);
            }
        }

        return elements;
    }

    if ((IsIE() || 10) == 7) {
        return true; // do no execute code pass this point for IE7 (axis highlight and selection causes problems with display in IE7)
    }

    $("table.grid.enableAxisHighlighting")
        .on("mousemove", function (args) {
            var target = $(args.target).closest(".gridItem:not(.gridColumnHeader)");
            var highlightedElements = $(".gridHighlightedAxis", this);
            var elementsToHighlight = GetAxisElements(target);

            removeBackgroundColorStyle(highlightedElements.not(elementsToHighlight), "gridHighlightedAxis");
            addBackgroundColorStyle(elementsToHighlight, "gridHighlightedAxis");
        })
        .on("mouseleave", function (args) {
            removeBackgroundColorStyle($(".gridHighlightedAxis", this), "gridHighlightedAxis");
        });

    $("table.grid.enableAxisSelection tbody .gridRow .gridItem:not(.gridColumnHeader), table.grid.enableAxisSelection tbody .gridAlternateRow .gridItem:not(.gridColumnHeader)")
        .on("click", function () {
            if (!$(document).data("events") || !$(document).data("events").click) {
                $(document).on("click", function (_e) {
                    if (!$(_e.target).parents().hasClass("grid")) {
                        removeBackgroundColorStyle($("table.grid").find(".gridSelectedAxis"), "gridSelectedAxis");
                        $(document).off("click");
                    }
                });
            }

            removeBackgroundColorStyle($("table.grid").find(".gridSelectedAxis"), "gridSelectedAxis");
            addBackgroundColorStyle(GetAxisElements($(this)), "gridSelectedAxis");
        });
}

function GetRows(_clickedRow) {
    var _rows;

    if (_clickedRow.hasClass("gridErrorRow"))
        _rows = _clickedRow.prev().andSelf();
    else if (_clickedRow.next().hasClass("gridErrorRow"))
        _rows = _clickedRow.next().andSelf();
    else
        _rows = _clickedRow;

    return _rows;
}

function refreshHeaderRepeat(row) {
    var grid = $(row).parents("table.grid");
    refreshGridHeaders(grid);
}

function refreshGridHeaders(grid) {
    if (grid.data("gridrepeatheaders") > 0) {
        var repeatHeadersEvery = grid.data("gridrepeatheaders");
        var headerRows = getGridHeaderRows(grid);

        $("tbody tr.gridRepeatedHeaderRow", grid).remove();
        var rows = grid.children("tbody").children("tr:visible:not(.gridErrorRow)");

        for (var i = (headerRows.length + repeatHeadersEvery); i < rows.length; i = i + repeatHeadersEvery) {
            for (var x = 0; x < headerRows.length ; x++) {
                var repeatedHeader = $(headerRows[x]).clone();
                repeatedHeader.addClass("gridRepeatedHeaderRow");

                $("th", repeatedHeader).each(function () {
                    var id = $(this).attr("id");

                    $(this).attr("id", id + "_" + i);
                });

                // Check if the target row has a preceding error row. If so, insert the
                // repeated header before the error row to maintain proper error-row-variable association
                var targetRow = $(rows[i]);
                var previousElement = targetRow.prev();

                if (previousElement.hasClass('gridErrorRow')) {
                    // Insert header before error row to maintain error-row association
                    previousElement.before(repeatedHeader);
                } else {
                    // Normal insertion - no error row present
                    targetRow.before(repeatedHeader);
                }
            }
        }
    }
}

function getGridHeaderRows(grid) {
    var elements = new Array();

    $("tr", grid).each(function (index) {
        if ($(this).children("th.gridColumnHeader").length > 0)
            elements.push($(this));
        else if (elements.length > 0)
            return false;
    });

    return elements;
}

function initGridOpenEnds() {
    var grids = $("table.grid");

    // Enable all open-ends for each grid that only has open-ends
    for (var gridIndex = 0; gridIndex < grids.length; gridIndex++) {
        var grid = grids[gridIndex];
        var hasNonOpenEndControls =
            $("input.textAnswer, input.numericAnswer, div.choiceContainer, div.choiceImage, input.sliderValue, input.starRatingValue", grid)
                .not(".openEnd")
                .length > 0;

        if (!hasNonOpenEndControls) {
            var openEnds = $("textarea.openEnd", grid);
            setOpenEndEnabledOrDisabled(openEnds, false);
        }
    }
}